
#include <math.h>

int pinI1 = 2;//define I1 interface: used to be pin 8
int pinI2 = 4;//define I2 interface: used to be pin 11
int speedpinA = 3;//enable motor A: used to be pin 9
int pinI3 = 5;//define I3 interface: used to be pin 12
int pinI4 = 7;//define I4 interface: used to be pin 13
int speedpinB = 6;//enable motor B: used to be pin 10
int rate = 255;//define the speed of motor
float center = 2.31;
float sensorValue = 2.31;
float voltage = 0;
boolean pressed = false;
int incomingByte = 0;
int test = 0;

float mic_val = 0;
float mic_voltage = 0;


void setup()
{
  pinMode(pinI1,OUTPUT);
  pinMode(pinI2,OUTPUT);
  pinMode(speedpinA,OUTPUT);
  pinMode(pinI3,OUTPUT);
  pinMode(pinI4,OUTPUT);
  pinMode(speedpinB,OUTPUT);
  
  Serial.begin(9600);
}

void forward(){
  analogWrite(speedpinA,rate);//input a simulation value to set the speed
  digitalWrite(pinI2,LOW);//turn DC Motor A move anticlockwise
  digitalWrite(pinI1,HIGH);
}

void backward(){
  analogWrite(speedpinA,rate);//input a simulation value to set the speed
  digitalWrite(pinI2,HIGH);//turn DC Motor A move anticlockwise
  digitalWrite(pinI1,LOW);
}

void left(){
  analogWrite(speedpinB,rate);
  digitalWrite(pinI4,HIGH);
  digitalWrite(pinI3,LOW); 
}

void right(){
  analogWrite(speedpinB,rate);
  digitalWrite(pinI4,LOW);
  digitalWrite(pinI3,HIGH); 
}

void brake(){
  digitalWrite(speedpinA,LOW);
}

void turnbrake(){
  digitalWrite(speedpinB,LOW);
}

void loop(){
  
  sensorValue = analogRead(A0);

  voltage = sensorValue * (5.0 / 1023.0);

  
  if (Serial.available() > 0){
    pressed = true;
    incomingByte = Serial.read();
    
    if(incomingByte == 1){
      forward();
    }
    
    else if(incomingByte == 2){
      backward();
    }
    
    else if(incomingByte == 3 && voltage > 1.2 && voltage < 3.5){
       right();
       delay(100);
       turnbrake();
    }
    
    else if(incomingByte == 4 && voltage < 3.5 && voltage > 1.2){
      left();
      delay(100); 
      turnbrake(); 
    }
    
    else if(incomingByte == 5){
      brake();
    }
    
    else if(incomingByte == 6){
      turnbrake();
      pressed = false;
    }
  }
  
  
  else if (!pressed){
    while(fabs(voltage - center) > 0.25){
          if(voltage > 4.0 || voltage < 0.8) break;
          
          else if(voltage > center){
            left();
            delay(1);
            turnbrake();
            //Serial.println("trying to turn right because: ");
            //Serial.println(voltage);
          }
          else if(center > voltage){
            right();
            delay(1);
            turnbrake();
            
            //Serial.println("trying to turn left because: ");
            //Serial.println(voltage);
          }
          
          else turnbrake();
          
          sensorValue = analogRead(A0);
          voltage = sensorValue * (5.0 / 1023.0);
          delay(1);
        }
  }

  delay(1);
}
